/* ChannelFactory.c generated by valac 0.25.1, the Vala compiler
 * generated from ChannelFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gst/mpegts/mpegts.h>
#include <gobject/gvaluecollector.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;
typedef struct _DVBPlayerThreadPrivate DVBPlayerThreadPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS (dvb_player_thread_channel_elements_get_type ())
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElements))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_IS_CHANNEL_ELEMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS))
#define DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElementsClass))

typedef struct _DVBPlayerThreadChannelElements DVBPlayerThreadChannelElements;
typedef struct _DVBPlayerThreadChannelElementsClass DVBPlayerThreadChannelElementsClass;

#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_player_thread_channel_elements_unref0(var) ((var == NULL) ? NULL : (var = (dvb_player_thread_channel_elements_unref (var), NULL)))
typedef struct _DVBPlayerThreadChannelElementsPrivate DVBPlayerThreadChannelElementsPrivate;
#define _gst_iterator_free0(var) ((var == NULL) ? NULL : (var = (gst_iterator_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define __vala_GstMpegtsSection_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstMpegtsSection_free (var), NULL)))
typedef struct _DVBPlayerThreadParamSpecChannelElements DVBPlayerThreadParamSpecChannelElements;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;
typedef struct _DVBChannelFactoryPrivate DVBChannelFactoryPrivate;

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBPlayerThread {
	GObject parent_instance;
	DVBPlayerThreadPrivate * priv;
};

struct _DVBPlayerThreadClass {
	GObjectClass parent_class;
	void (*destroy) (DVBPlayerThread* self, gboolean forced);
};

struct _DVBPlayerThreadPrivate {
	GeeHashSet* _active_channels;
	DVBDevice* _device;
	DVBDeviceGroup* _group;
	GstElement* pipeline;
	GRecMutex __lock_pipeline;
	GeeHashMap* elements_map;
	GRecMutex __lock_elements_map;
	DVBEPGScanner* epgscanner;
	GstElement* dvbbasebin;
	gboolean destroyed;
	GRecMutex __lock_destroyed;
};

struct _DVBPlayerThreadChannelElements {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBPlayerThreadChannelElementsPrivate * priv;
	guint sid;
	GeeArrayList* sinks;
	GstElement* tee;
	gboolean forced;
	DVBForcedStopNotify notify_func;
	gpointer notify_func_target;
};

struct _DVBPlayerThreadChannelElementsClass {
	GTypeClass parent_class;
	void (*finalize) (DVBPlayerThreadChannelElements *self);
};

struct _DVBPlayerThreadParamSpecChannelElements {
	GParamSpec parent_instance;
};

struct _DVBChannelFactory {
	GObject parent_instance;
	DVBChannelFactoryPrivate * priv;
};

struct _DVBChannelFactoryClass {
	GObjectClass parent_class;
	DVBPlayerThread* (*create_player) (DVBChannelFactory* self, DVBDevice* device);
};

struct _DVBChannelFactoryPrivate {
	DVBDeviceGroup* _device_group;
	GeeHashSet* active_players;
	GRecMutex __lock_active_players;
};


static gpointer dvb_player_thread_parent_class = NULL;
static DVBLoggingLogger* dvb_player_thread_log;
static DVBLoggingLogger* dvb_player_thread_log = NULL;
static gpointer dvb_player_thread_channel_elements_parent_class = NULL;
static gpointer dvb_channel_factory_parent_class = NULL;
static DVBLoggingLogger* dvb_channel_factory_log;
static DVBLoggingLogger* dvb_channel_factory_log = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_player_thread_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
static gpointer dvb_player_thread_channel_elements_ref (gpointer instance);
static void dvb_player_thread_channel_elements_unref (gpointer instance);
static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) G_GNUC_UNUSED;
static GType dvb_player_thread_channel_elements_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType dvb_epg_scanner_get_type (void) G_GNUC_CONST;
#define DVB_PLAYER_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadPrivate))
enum  {
	DVB_PLAYER_THREAD_DUMMY_PROPERTY,
	DVB_PLAYER_THREAD_ACTIVE_CHANNELS,
	DVB_PLAYER_THREAD_DEVICE,
	DVB_PLAYER_THREAD_GROUP,
	DVB_PLAYER_THREAD_FORCED
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner, DVBDeviceGroup* group);
DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner, DVBDeviceGroup* group);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self);
GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message);
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem);
static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element);
static void dvb_player_thread_link_tee_pad (DVBPlayerThread* self, GstElement* dvbbasebin, GstElement* tee);
GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void);
static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type);
static gint dvb_player_thread_find_element (GValue* av, GstElement* bv);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
static gint _dvb_player_thread_find_element_gsearch_func (gconstpointer a, gconstpointer b);
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink);
static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self);
static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink);
void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced);
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced);
DVBDeviceGroup* dvb_player_thread_get_group (DVBPlayerThread* self);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, GstMpegtsSection* section);
static void _vala_GstMpegtsSection_free (GstMpegtsSection* self);
static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value);
static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value);
static void dvb_player_thread_set_group (DVBPlayerThread* self, DVBDeviceGroup* value);
gboolean dvb_player_thread_get_forced (DVBPlayerThread* self);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_DUMMY_PROPERTY
};
static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj);
static void dvb_player_thread_finalize (GObject* obj);
static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_channel_factory_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryPrivate))
enum  {
	DVB_CHANNEL_FACTORY_DUMMY_PROPERTY,
	DVB_CHANNEL_FACTORY_DEVICE_GROUP
};
DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup);
DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup);
void dvb_channel_factory_destroy (DVBChannelFactory* self);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device);
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device);
DVBEPGScanner* dvb_device_group_get_epgscanner (DVBDeviceGroup* self);
static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value);
static void dvb_channel_factory_finalize (GObject* obj);
static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
         * @device: The device to use
         * @epgscanner: #EPGScanner to forward EIT to
         * @group: #DeviceGroup
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DVBPlayerThread* dvb_player_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner, DVBDeviceGroup* group) {
	DVBPlayerThread * self = NULL;
	DVBDevice* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	DVBEPGScanner* _tmp2_ = NULL;
	DVBEPGScanner* _tmp3_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = group;
	self = (DVBPlayerThread*) g_object_new (object_type, "device", _tmp0_, "group", _tmp1_, NULL);
	_tmp2_ = epgscanner;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->epgscanner);
	self->priv->epgscanner = _tmp3_;
	return self;
}


DVBPlayerThread* dvb_player_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner, DVBDeviceGroup* group) {
	return dvb_player_thread_construct (DVB_TYPE_PLAYER_THREAD, device, epgscanner, group);
}


GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


GstElement* dvb_player_thread_get_dvbbasebin (DVBPlayerThread* self) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dvbbasebin;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
         * @returns: GstBin containing queue and @sink_element
         *
         * Start watching @channel and link it with @sink_element
         */
static void _dvb_player_thread_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_player_thread_bus_watch_func ((DVBPlayerThread*) self, _sender, message);
}


GstElement* dvb_player_thread_get_element (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink_element, gboolean forced, DVBForcedStopNotify notify_func, void* notify_func_target) {
	GstElement* result = NULL;
	guint channel_sid = 0U;
	DVBChannel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gchar* channel_sid_str = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gboolean create_channel = FALSE;
	GstElement* bin = NULL;
	GstElement* tee = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Sid (_tmp0_);
	_tmp2_ = _tmp1_;
	channel_sid = _tmp2_;
	_tmp3_ = channel_sid;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	channel_sid_str = _tmp4_;
	tee = NULL;
	{
		GstElement* _tmp5_ = NULL;
		_tmp5_ = self->priv->pipeline;
		g_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* _tmp6_ = NULL;
			gboolean _tmp100_ = FALSE;
			GstElement* _tmp124_ = NULL;
			GstElement* _tmp125_ = NULL;
			_tmp6_ = self->priv->pipeline;
			if (_tmp6_ == NULL) {
				DVBLoggingLogger* _tmp7_ = NULL;
				GstPipeline* _tmp8_ = NULL;
				GstBus* bus = NULL;
				GstElement* _tmp9_ = NULL;
				GstBus* _tmp10_ = NULL;
				GstBus* _tmp11_ = NULL;
				GstBus* _tmp12_ = NULL;
				GstElement* _tmp13_ = NULL;
				GstElement* _tmp14_ = NULL;
				DVBChannel* _tmp17_ = NULL;
				GstElement* _tmp18_ = NULL;
				GstElement* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GstElement* _tmp21_ = NULL;
				DVBDevice* _tmp22_ = NULL;
				guint _tmp23_ = 0U;
				guint _tmp24_ = 0U;
				GstElement* _tmp25_ = NULL;
				DVBDevice* _tmp26_ = NULL;
				guint _tmp27_ = 0U;
				guint _tmp28_ = 0U;
				GstElement* _tmp29_ = NULL;
				GstElement* _tmp30_ = NULL;
				GstElement* _tmp31_ = NULL;
				GstElement* _tmp32_ = NULL;
				GstElement* _tmp33_ = NULL;
				GstElement* _tmp34_ = NULL;
				GstElement* _tmp35_ = NULL;
				GstElement* _tmp36_ = NULL;
				GstElement* _tmp37_ = NULL;
				GstElement* _tmp39_ = NULL;
				GstElement* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
				GstElement* _tmp44_ = NULL;
				GstElement* _tmp45_ = NULL;
				_tmp7_ = dvb_player_thread_log;
				dvb_logging_logger_debug (_tmp7_, "ChannelFactory.vala:121: Creating new pipeline");
				_tmp8_ = (GstPipeline*) gst_pipeline_new ("recording");
				g_object_ref_sink (_tmp8_);
				_g_object_unref0 (self->priv->pipeline);
				self->priv->pipeline = (GstElement*) _tmp8_;
				_tmp9_ = self->priv->pipeline;
				_tmp10_ = gst_element_get_bus (_tmp9_);
				bus = _tmp10_;
				_tmp11_ = bus;
				gst_bus_add_signal_watch_full (_tmp11_, G_PRIORITY_DEFAULT);
				_tmp12_ = bus;
				g_signal_connect_object (_tmp12_, "message", (GCallback) _dvb_player_thread_bus_watch_func_gst_bus_message, self, 0);
				_tmp13_ = gst_element_factory_make ("dvbbasebin", NULL);
				if (_tmp13_ != NULL) {
					g_object_ref_sink (_tmp13_);
				}
				_g_object_unref0 (self->priv->dvbbasebin);
				self->priv->dvbbasebin = _tmp13_;
				_tmp14_ = self->priv->dvbbasebin;
				if (_tmp14_ == NULL) {
					DVBLoggingLogger* _tmp15_ = NULL;
					_tmp15_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp15_, "ChannelFactory.vala:132: Could not create dvbbasebin element");
					result = NULL;
					_g_object_unref0 (bus);
					{
						GstElement* _tmp16_ = NULL;
						_tmp16_ = self->priv->pipeline;
						g_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_object_unref0 (tee);
					_g_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_g_object_unref0 (sink_element);
					return result;
				}
				_tmp17_ = channel;
				_tmp18_ = self->priv->dvbbasebin;
				dvb_channel_setup_dvb_source (_tmp17_, _tmp18_);
				_tmp19_ = self->priv->dvbbasebin;
				_tmp20_ = channel_sid_str;
				g_object_set ((GObject*) _tmp19_, "program-numbers", _tmp20_, NULL);
				_tmp21_ = self->priv->dvbbasebin;
				_tmp22_ = self->priv->_device;
				_tmp23_ = dvb_device_get_Adapter (_tmp22_);
				_tmp24_ = _tmp23_;
				g_object_set ((GObject*) _tmp21_, "adapter", _tmp24_, NULL);
				_tmp25_ = self->priv->dvbbasebin;
				_tmp26_ = self->priv->_device;
				_tmp27_ = dvb_device_get_Frontend (_tmp26_);
				_tmp28_ = _tmp27_;
				g_object_set ((GObject*) _tmp25_, "frontend", _tmp28_, NULL);
				_tmp29_ = self->priv->pipeline;
				_tmp30_ = self->priv->dvbbasebin;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gst_bin_get_type (), GstBin), _tmp31_);
				_tmp32_ = gst_element_factory_make ("tee", NULL);
				if (_tmp32_ != NULL) {
					g_object_ref_sink (_tmp32_);
				}
				_g_object_unref0 (tee);
				tee = _tmp32_;
				_tmp33_ = tee;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				dvb_player_thread_add_element (self, _tmp34_);
				_tmp35_ = sink_element;
				_tmp36_ = dvb_player_thread_add_sink_bin (self, _tmp35_);
				_g_object_unref0 (bin);
				bin = _tmp36_;
				_tmp37_ = bin;
				if (_tmp37_ == NULL) {
					DVBLoggingLogger* _tmp38_ = NULL;
					_tmp38_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp38_, "ChannelFactory.vala:150: no bin");
				}
				_tmp39_ = tee;
				_tmp40_ = bin;
				_tmp41_ = gst_element_link (_tmp39_, _tmp40_);
				if (!_tmp41_) {
					DVBLoggingLogger* _tmp42_ = NULL;
					_tmp42_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp42_, "ChannelFactory.vala:152: Could not link tee and bin");
					result = NULL;
					_g_object_unref0 (bus);
					{
						GstElement* _tmp43_ = NULL;
						_tmp43_ = self->priv->pipeline;
						g_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_object_unref0 (tee);
					_g_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_g_object_unref0 (sink_element);
					return result;
				}
				_tmp44_ = self->priv->dvbbasebin;
				_tmp45_ = tee;
				dvb_player_thread_link_tee_pad (self, _tmp44_, _tmp45_);
				create_channel = TRUE;
				_g_object_unref0 (bus);
			} else {
				DVBLoggingLogger* _tmp46_ = NULL;
				GstElement* _tmp47_ = NULL;
				GstElement* _tmp50_ = NULL;
				GeeHashSet* _tmp51_ = NULL;
				DVBChannel* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
				_tmp46_ = dvb_player_thread_log;
				dvb_logging_logger_debug (_tmp46_, "ChannelFactory.vala:162: Reusing existing pipeline");
				_tmp47_ = self->priv->dvbbasebin;
				if (_tmp47_ == NULL) {
					DVBLoggingLogger* _tmp48_ = NULL;
					_tmp48_ = dvb_player_thread_log;
					dvb_logging_logger_error (_tmp48_, "ChannelFactory.vala:164: No dvbbasebin element");
					result = NULL;
					{
						GstElement* _tmp49_ = NULL;
						_tmp49_ = self->priv->pipeline;
						g_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_object_unref0 (tee);
					_g_object_unref0 (bin);
					_g_free0 (channel_sid_str);
					_g_object_unref0 (sink_element);
					return result;
				}
				_tmp50_ = self->priv->pipeline;
				gst_element_set_state (_tmp50_, GST_STATE_PAUSED);
				_tmp51_ = self->priv->_active_channels;
				_tmp52_ = channel;
				_tmp53_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp51_, _tmp52_);
				if (!_tmp53_) {
					GstElement* _tmp54_ = NULL;
					GstElement* _tmp55_ = NULL;
					GstElement* _tmp56_ = NULL;
					GstElement* _tmp57_ = NULL;
					GstElement* _tmp58_ = NULL;
					GstElement* _tmp59_ = NULL;
					GstElement* _tmp60_ = NULL;
					gboolean _tmp61_ = FALSE;
					gchar* programs = NULL;
					GstElement* _tmp64_ = NULL;
					gchar* new_programs = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					DVBLoggingLogger* _tmp68_ = NULL;
					const gchar* _tmp69_ = NULL;
					const gchar* _tmp70_ = NULL;
					GstElement* _tmp71_ = NULL;
					const gchar* _tmp72_ = NULL;
					_tmp54_ = gst_element_factory_make ("tee", NULL);
					if (_tmp54_ != NULL) {
						g_object_ref_sink (_tmp54_);
					}
					_g_object_unref0 (tee);
					tee = _tmp54_;
					_tmp55_ = tee;
					_tmp56_ = _g_object_ref0 (_tmp55_);
					dvb_player_thread_add_element (self, _tmp56_);
					_tmp57_ = sink_element;
					_tmp58_ = dvb_player_thread_add_sink_bin (self, _tmp57_);
					_g_object_unref0 (bin);
					bin = _tmp58_;
					_tmp59_ = tee;
					_tmp60_ = bin;
					_tmp61_ = gst_element_link (_tmp59_, _tmp60_);
					if (!_tmp61_) {
						DVBLoggingLogger* _tmp62_ = NULL;
						_tmp62_ = dvb_player_thread_log;
						dvb_logging_logger_error (_tmp62_, "ChannelFactory.vala:178: Could not link tee and bin");
						result = NULL;
						{
							GstElement* _tmp63_ = NULL;
							_tmp63_ = self->priv->pipeline;
							g_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_g_object_unref0 (tee);
						_g_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_g_object_unref0 (sink_element);
						return result;
					}
					_tmp64_ = self->priv->dvbbasebin;
					g_object_get ((GObject*) _tmp64_, "program-numbers", &programs, NULL);
					_tmp65_ = programs;
					_tmp66_ = channel_sid_str;
					_tmp67_ = g_strdup_printf ("%s:%s", _tmp65_, _tmp66_);
					new_programs = _tmp67_;
					_tmp68_ = dvb_player_thread_log;
					_tmp69_ = programs;
					_tmp70_ = new_programs;
					dvb_logging_logger_debug (_tmp68_, "ChannelFactory.vala:187: Changing program-numbers from %s to %s", _tmp69_, _tmp70_);
					_tmp71_ = self->priv->dvbbasebin;
					_tmp72_ = new_programs;
					g_object_set ((GObject*) _tmp71_, "program-numbers", _tmp72_, NULL);
					create_channel = TRUE;
					_g_free0 (new_programs);
					_g_free0 (programs);
				} else {
					DVBPlayerThreadChannelElements* c_element = NULL;
					{
						GeeHashMap* _tmp73_ = NULL;
						_tmp73_ = self->priv->elements_map;
						g_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							GeeHashMap* _tmp74_ = NULL;
							guint _tmp75_ = 0U;
							gpointer _tmp76_ = NULL;
							DVBPlayerThreadChannelElements* _tmp77_ = NULL;
							GstElement* _tmp78_ = NULL;
							GstElement* _tmp79_ = NULL;
							GstElement* _tmp80_ = NULL;
							GstElement* _tmp81_ = NULL;
							DVBLoggingLogger* _tmp82_ = NULL;
							GstElement* _tmp83_ = NULL;
							gchar* _tmp84_ = NULL;
							gchar* _tmp85_ = NULL;
							GstElement* _tmp86_ = NULL;
							gchar* _tmp87_ = NULL;
							gchar* _tmp88_ = NULL;
							GstElement* _tmp89_ = NULL;
							GstElement* _tmp90_ = NULL;
							gboolean _tmp91_ = FALSE;
							DVBPlayerThreadChannelElements* _tmp95_ = NULL;
							GeeArrayList* _tmp96_ = NULL;
							GstElement* _tmp97_ = NULL;
							_tmp74_ = self->priv->elements_map;
							_tmp75_ = channel_sid;
							_tmp76_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp74_, (gpointer) ((guintptr) _tmp75_));
							_dvb_player_thread_channel_elements_unref0 (c_element);
							c_element = (DVBPlayerThreadChannelElements*) _tmp76_;
							_tmp77_ = c_element;
							_tmp78_ = _tmp77_->tee;
							_tmp79_ = _g_object_ref0 (_tmp78_);
							_g_object_unref0 (tee);
							tee = _tmp79_;
							_tmp80_ = sink_element;
							_tmp81_ = dvb_player_thread_add_sink_bin (self, _tmp80_);
							_g_object_unref0 (bin);
							bin = _tmp81_;
							_tmp82_ = dvb_player_thread_log;
							_tmp83_ = tee;
							_tmp84_ = gst_object_get_name ((GstObject*) _tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = bin;
							_tmp87_ = gst_object_get_name ((GstObject*) _tmp86_);
							_tmp88_ = _tmp87_;
							dvb_logging_logger_debug (_tmp82_, "ChannelFactory.vala:202: Linking %s with %s", _tmp85_, _tmp88_);
							_g_free0 (_tmp88_);
							_g_free0 (_tmp85_);
							_tmp89_ = tee;
							_tmp90_ = bin;
							_tmp91_ = gst_element_link (_tmp89_, _tmp90_);
							if (!_tmp91_) {
								DVBLoggingLogger* _tmp92_ = NULL;
								_tmp92_ = dvb_player_thread_log;
								dvb_logging_logger_error (_tmp92_, "ChannelFactory.vala:204: Could not link tee and bin");
								result = NULL;
								{
									GeeHashMap* _tmp93_ = NULL;
									_tmp93_ = self->priv->elements_map;
									g_rec_mutex_unlock (&self->priv->__lock_elements_map);
								}
								_dvb_player_thread_channel_elements_unref0 (c_element);
								{
									GstElement* _tmp94_ = NULL;
									_tmp94_ = self->priv->pipeline;
									g_rec_mutex_unlock (&self->priv->__lock_pipeline);
								}
								_g_object_unref0 (tee);
								_g_object_unref0 (bin);
								_g_free0 (channel_sid_str);
								_g_object_unref0 (sink_element);
								return result;
							}
							_tmp95_ = c_element;
							_tmp96_ = _tmp95_->sinks;
							_tmp97_ = bin;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, _tmp97_);
						}
						__finally15:
						{
							GeeHashMap* _tmp98_ = NULL;
							_tmp98_ = self->priv->elements_map;
							g_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_dvb_player_thread_channel_elements_unref0 (c_element);
							_dvb_player_thread_channel_elements_unref0 (c_element);
							{
								GstElement* _tmp99_ = NULL;
								_tmp99_ = self->priv->pipeline;
								g_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_g_object_unref0 (tee);
							_g_object_unref0 (bin);
							_g_free0 (channel_sid_str);
							_g_object_unref0 (sink_element);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					create_channel = FALSE;
					_dvb_player_thread_channel_elements_unref0 (c_element);
				}
			}
			_tmp100_ = create_channel;
			if (_tmp100_) {
				DVBPlayerThreadChannelElements* celems = NULL;
				DVBPlayerThreadChannelElements* _tmp101_ = NULL;
				DVBPlayerThreadChannelElements* _tmp102_ = NULL;
				guint _tmp103_ = 0U;
				DVBPlayerThreadChannelElements* _tmp104_ = NULL;
				GeeArrayList* _tmp105_ = NULL;
				DVBPlayerThreadChannelElements* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GstElement* _tmp108_ = NULL;
				DVBPlayerThreadChannelElements* _tmp109_ = NULL;
				GstElement* _tmp110_ = NULL;
				GstElement* _tmp111_ = NULL;
				DVBPlayerThreadChannelElements* _tmp112_ = NULL;
				gboolean _tmp113_ = FALSE;
				DVBPlayerThreadChannelElements* _tmp114_ = NULL;
				DVBForcedStopNotify _tmp115_ = NULL;
				void* _tmp115__target = NULL;
				GeeHashSet* _tmp122_ = NULL;
				DVBChannel* _tmp123_ = NULL;
				_tmp101_ = dvb_player_thread_channel_elements_new ();
				celems = _tmp101_;
				_tmp102_ = celems;
				_tmp103_ = channel_sid;
				_tmp102_->sid = _tmp103_;
				_tmp104_ = celems;
				_tmp105_ = gee_array_list_new (gst_element_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (_tmp104_->sinks);
				_tmp104_->sinks = _tmp105_;
				_tmp106_ = celems;
				_tmp107_ = _tmp106_->sinks;
				_tmp108_ = bin;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
				_tmp109_ = celems;
				_tmp110_ = tee;
				_tmp111_ = _g_object_ref0 (_tmp110_);
				_g_object_unref0 (_tmp109_->tee);
				_tmp109_->tee = _tmp111_;
				_tmp112_ = celems;
				_tmp113_ = forced;
				_tmp112_->forced = _tmp113_;
				_tmp114_ = celems;
				_tmp115_ = notify_func;
				_tmp115__target = notify_func_target;
				_tmp114_->notify_func = _tmp115_;
				_tmp114_->notify_func_target = _tmp115__target;
				{
					GeeHashMap* _tmp116_ = NULL;
					_tmp116_ = self->priv->elements_map;
					g_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						GeeHashMap* _tmp117_ = NULL;
						guint _tmp118_ = 0U;
						DVBPlayerThreadChannelElements* _tmp119_ = NULL;
						_tmp117_ = self->priv->elements_map;
						_tmp118_ = channel_sid;
						_tmp119_ = celems;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp117_, (gpointer) ((guintptr) _tmp118_), _tmp119_);
					}
					__finally16:
					{
						GeeHashMap* _tmp120_ = NULL;
						_tmp120_ = self->priv->elements_map;
						g_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_dvb_player_thread_channel_elements_unref0 (celems);
						_dvb_player_thread_channel_elements_unref0 (celems);
						{
							GstElement* _tmp121_ = NULL;
							_tmp121_ = self->priv->pipeline;
							g_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_g_object_unref0 (tee);
						_g_object_unref0 (bin);
						_g_free0 (channel_sid_str);
						_g_object_unref0 (sink_element);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp122_ = self->priv->_active_channels;
				_tmp123_ = channel;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, _tmp123_);
				_dvb_player_thread_channel_elements_unref0 (celems);
			}
			_tmp124_ = bin;
			_tmp125_ = _g_object_ref0 (_tmp124_);
			result = _tmp125_;
			{
				GstElement* _tmp126_ = NULL;
				_tmp126_ = self->priv->pipeline;
				g_rec_mutex_unlock (&self->priv->__lock_pipeline);
			}
			_g_object_unref0 (tee);
			_g_object_unref0 (bin);
			_g_free0 (channel_sid_str);
			_g_object_unref0 (sink_element);
			return result;
		}
		__finally14:
		{
			GstElement* _tmp127_ = NULL;
			_tmp127_ = self->priv->pipeline;
			g_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		_g_object_unref0 (tee);
		_g_object_unref0 (bin);
		_g_free0 (channel_sid_str);
		_g_object_unref0 (sink_element);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (tee);
	_g_object_unref0 (bin);
	_g_free0 (channel_sid_str);
	_g_object_unref0 (sink_element);
}


static GstElement* dvb_player_thread_add_sink_bin (DVBPlayerThread* self, GstElement* sink_element) {
	GstElement* result = NULL;
	GstElement* queue = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* bin = NULL;
	GstBin* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GstPad* pad = NULL;
	GstElement* _tmp18_ = NULL;
	GstPad* _tmp19_ = NULL;
	GstGhostPad* ghost = NULL;
	GstGhostPad* _tmp20_ = NULL;
	GstElement* _tmp21_ = NULL;
	GstPad* _tmp22_ = NULL;
	GstElement* _tmp23_ = NULL;
	GstElement* _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = gst_element_factory_make ("queue", NULL);
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	queue = _tmp0_;
	_tmp1_ = queue;
	g_object_set ((GObject*) _tmp1_, "max-size-buffers", 0, NULL);
	_tmp2_ = (GstBin*) gst_bin_new ("sink_bin");
	g_object_ref_sink (_tmp2_);
	bin = (GstElement*) _tmp2_;
	_tmp3_ = bin;
	_tmp4_ = queue;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = sink_element;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	gst_bin_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gst_bin_get_type (), GstBin), _tmp5_, _tmp7_, NULL);
	_tmp8_ = queue;
	_tmp9_ = sink_element;
	_tmp10_ = gst_element_link (_tmp8_, _tmp9_);
	if (!_tmp10_) {
		DVBLoggingLogger* _tmp11_ = NULL;
		GstElement* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GstElement* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp11_ = dvb_player_thread_log;
		_tmp12_ = queue;
		_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = sink_element;
		_tmp16_ = gst_object_get_name ((GstObject*) _tmp15_);
		_tmp17_ = _tmp16_;
		dvb_logging_logger_error (_tmp11_, "ChannelFactory.vala:240: Could not link elements %s and %s", _tmp14_, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
	}
	_tmp18_ = queue;
	_tmp19_ = gst_element_get_static_pad (_tmp18_, "sink");
	pad = _tmp19_;
	_tmp20_ = (GstGhostPad*) gst_ghost_pad_new ("sink", pad);
	g_object_ref_sink (_tmp20_);
	ghost = _tmp20_;
	gst_pad_set_active ((GstPad*) ghost, TRUE);
	_tmp21_ = bin;
	_tmp22_ = _g_object_ref0 ((GstPad*) ghost);
	gst_element_add_pad (_tmp21_, _tmp22_);
	_tmp23_ = bin;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	dvb_player_thread_add_element (self, _tmp24_);
	result = bin;
	_g_object_unref0 (ghost);
	_g_object_unref0 (pad);
	_g_object_unref0 (queue);
	return result;
}


static gint dvb_player_thread_find_element (GValue* av, GstElement* bv) {
	gint result = 0;
	GstElement* a = NULL;
	GValue _tmp0_ = {0};
	GstElement* _tmp1_ = NULL;
	GstElement* b = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	g_return_val_if_fail (av != NULL, 0);
	g_return_val_if_fail (bv != NULL, 0);
	_tmp0_ = *av;
	_tmp1_ = _g_object_ref0 (g_value_get_object (&_tmp0_));
	a = _tmp1_;
	_tmp2_ = bv;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_element_get_type (), GstElement));
	b = _tmp3_;
	_tmp4_ = a;
	_tmp5_ = b;
	if (_tmp4_ == _tmp5_) {
		result = 0;
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	} else {
		result = 1;
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		return result;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (a);
}


/**
         * @sid: Channel SID
         * @sink: The sink element that the bin should contain
         * @returns: GstBin containing queue and sink for the specified channel
         */
static gint _dvb_player_thread_find_element_gsearch_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = dvb_player_thread_find_element (a, (GstElement*) b);
	return result;
}


GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink) {
	GstElement* result = NULL;
	GstElement* _result_ = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GstElement* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sink != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = dvb_player_thread_log;
	_tmp1_ = sink;
	_tmp2_ = gst_object_get_name ((GstObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sink;
	_tmp5_ = sid;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:270: Searching for sink %s (%p) of channel %u", _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_tmp3_);
	{
		GeeHashMap* _tmp6_ = NULL;
		_tmp6_ = self->priv->elements_map;
		g_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			DVBPlayerThreadChannelElements* celems = NULL;
			GeeHashMap* _tmp7_ = NULL;
			guint _tmp8_ = 0U;
			gpointer _tmp9_ = NULL;
			DVBPlayerThreadChannelElements* _tmp10_ = NULL;
			_tmp7_ = self->priv->elements_map;
			_tmp8_ = sid;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((guintptr) _tmp8_));
			celems = (DVBPlayerThreadChannelElements*) _tmp9_;
			_tmp10_ = celems;
			if (_tmp10_ != NULL) {
				{
					GeeArrayList* _sink_bin_list = NULL;
					DVBPlayerThreadChannelElements* _tmp11_ = NULL;
					GeeArrayList* _tmp12_ = NULL;
					GeeArrayList* _tmp13_ = NULL;
					gint _sink_bin_size = 0;
					GeeArrayList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _sink_bin_index = 0;
					_tmp11_ = celems;
					_tmp12_ = _tmp11_->sinks;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_sink_bin_list = _tmp13_;
					_tmp14_ = _sink_bin_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_sink_bin_size = _tmp16_;
					_sink_bin_index = -1;
					while (TRUE) {
						gint _tmp17_ = 0;
						gint _tmp18_ = 0;
						gint _tmp19_ = 0;
						GstElement* sink_bin = NULL;
						GeeArrayList* _tmp20_ = NULL;
						gint _tmp21_ = 0;
						gpointer _tmp22_ = NULL;
						GstIterator* it = NULL;
						GstElement* _tmp23_ = NULL;
						GstIterator* _tmp24_ = NULL;
						GValue elem = {0};
						GstIterator* _tmp25_ = NULL;
						GstElement* _tmp26_ = NULL;
						GValue _tmp27_ = {0};
						gboolean _tmp28_ = FALSE;
						_tmp17_ = _sink_bin_index;
						_sink_bin_index = _tmp17_ + 1;
						_tmp18_ = _sink_bin_index;
						_tmp19_ = _sink_bin_size;
						if (!(_tmp18_ < _tmp19_)) {
							break;
						}
						_tmp20_ = _sink_bin_list;
						_tmp21_ = _sink_bin_index;
						_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
						sink_bin = (GstElement*) _tmp22_;
						_tmp23_ = sink_bin;
						_tmp24_ = gst_bin_iterate_elements (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gst_bin_get_type (), GstBin));
						it = _tmp24_;
						_tmp25_ = it;
						_tmp26_ = sink;
						_tmp28_ = gst_iterator_find_custom (_tmp25_, (GCompareFunc) _dvb_player_thread_find_element_gsearch_func, &_tmp27_, _tmp26_);
						G_IS_VALUE (&elem) ? (g_value_unset (&elem), NULL) : NULL;
						elem = _tmp27_;
						if (_tmp28_) {
							GstElement* _tmp29_ = NULL;
							GstElement* _tmp30_ = NULL;
							_tmp29_ = sink_bin;
							_tmp30_ = _g_object_ref0 (_tmp29_);
							_g_object_unref0 (_result_);
							_result_ = _tmp30_;
							G_IS_VALUE (&elem) ? (g_value_unset (&elem), NULL) : NULL;
							_gst_iterator_free0 (it);
							_g_object_unref0 (sink_bin);
							break;
						}
						G_IS_VALUE (&elem) ? (g_value_unset (&elem), NULL) : NULL;
						_gst_iterator_free0 (it);
						_g_object_unref0 (sink_bin);
					}
					_g_object_unref0 (_sink_bin_list);
				}
			} else {
				guint _tmp31_ = 0U;
				_tmp31_ = sid;
				g_warning ("ChannelFactory.vala:283: Could not find any sinks of channel %u", _tmp31_);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally17:
		{
			GeeHashMap* _tmp32_ = NULL;
			_tmp32_ = self->priv->elements_map;
			g_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp33_ = _result_;
	if (_tmp33_ == NULL) {
		DVBLoggingLogger* _tmp34_ = NULL;
		_tmp34_ = dvb_player_thread_log;
		dvb_logging_logger_debug (_tmp34_, "ChannelFactory.vala:287: Found NO sink");
	} else {
		DVBLoggingLogger* _tmp35_ = NULL;
		_tmp35_ = dvb_player_thread_log;
		dvb_logging_logger_debug (_tmp35_, "ChannelFactory.vala:289: Found sink");
	}
	result = _result_;
	return result;
}


/**
         * Stop watching @channel
         */
gboolean dvb_player_thread_remove_channel (DVBPlayerThread* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	guint channel_sid = 0U;
	DVBChannel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GeeHashSet* _tmp3_ = NULL;
	DVBChannel* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DVBPlayerThreadChannelElements* celements = NULL;
	gboolean stop_channel = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Sid (_tmp0_);
	_tmp2_ = _tmp1_;
	channel_sid = _tmp2_;
	_tmp3_ = self->priv->_active_channels;
	_tmp4_ = channel;
	_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	if (!_tmp5_) {
		DVBLoggingLogger* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		_tmp6_ = dvb_player_thread_log;
		_tmp7_ = channel_sid;
		dvb_logging_logger_error (_tmp6_, "ChannelFactory.vala:300: Could not find channel with SID %u", _tmp7_);
		result = FALSE;
		return result;
	}
	{
		GeeHashMap* _tmp8_ = NULL;
		_tmp8_ = self->priv->elements_map;
		g_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			GeeHashMap* _tmp9_ = NULL;
			guint _tmp10_ = 0U;
			gpointer _tmp11_ = NULL;
			DVBPlayerThreadChannelElements* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			_tmp9_ = self->priv->elements_map;
			_tmp10_ = channel_sid;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) _tmp10_));
			_dvb_player_thread_channel_elements_unref0 (celements);
			celements = (DVBPlayerThreadChannelElements*) _tmp11_;
			_tmp12_ = celements;
			_tmp13_ = _tmp12_->sinks;
			_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			stop_channel = _tmp15_ == 1;
		}
		__finally18:
		{
			GeeHashMap* _tmp16_ = NULL;
			_tmp16_ = self->priv->elements_map;
			g_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	{
		GstElement* _tmp17_ = NULL;
		_tmp17_ = self->priv->pipeline;
		g_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GeeHashSet* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp18_ = self->priv->_active_channels;
			_tmp19_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ > 1) {
				gboolean _tmp21_ = FALSE;
				guint _tmp71_ = 0U;
				GstElement* _tmp72_ = NULL;
				gboolean _tmp73_ = FALSE;
				_tmp21_ = stop_channel;
				if (_tmp21_) {
					gchar* channel_sid_string = NULL;
					guint _tmp22_ = 0U;
					gchar* _tmp23_ = NULL;
					gchar* programs = NULL;
					GstElement* _tmp24_ = NULL;
					gchar** programs_arr = NULL;
					const gchar* _tmp25_ = NULL;
					gchar** _tmp26_ = NULL;
					gchar** _tmp27_ = NULL;
					gint programs_arr_length1 = 0;
					gint _programs_arr_size_ = 0;
					GeeArrayList* new_programs_list = NULL;
					GeeArrayList* _tmp28_ = NULL;
					GString* new_programs = NULL;
					GeeArrayList* _tmp41_ = NULL;
					gpointer _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					GString* _tmp44_ = NULL;
					GString* _tmp45_ = NULL;
					DVBLoggingLogger* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					GString* _tmp61_ = NULL;
					const gchar* _tmp62_ = NULL;
					GstElement* _tmp63_ = NULL;
					GstElement* _tmp64_ = NULL;
					GString* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gboolean _tmp67_ = FALSE;
					GeeHashSet* _tmp69_ = NULL;
					DVBChannel* _tmp70_ = NULL;
					_tmp22_ = channel_sid;
					_tmp23_ = g_strdup_printf ("%u", _tmp22_);
					channel_sid_string = _tmp23_;
					_tmp24_ = self->priv->dvbbasebin;
					g_object_get ((GObject*) _tmp24_, "program-numbers", &programs, NULL);
					_tmp25_ = programs;
					_tmp27_ = _tmp26_ = g_strsplit (_tmp25_, ":", 0);
					programs_arr = _tmp27_;
					programs_arr_length1 = _vala_array_length (_tmp26_);
					_programs_arr_size_ = programs_arr_length1;
					_tmp28_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
					new_programs_list = _tmp28_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp29_ = FALSE;
							_tmp29_ = TRUE;
							while (TRUE) {
								gint _tmp31_ = 0;
								gchar** _tmp32_ = NULL;
								gint _tmp32__length1 = 0;
								gchar** _tmp33_ = NULL;
								gint _tmp33__length1 = 0;
								gint _tmp34_ = 0;
								const gchar* _tmp35_ = NULL;
								const gchar* _tmp36_ = NULL;
								if (!_tmp29_) {
									gint _tmp30_ = 0;
									_tmp30_ = i;
									i = _tmp30_ + 1;
								}
								_tmp29_ = FALSE;
								_tmp31_ = i;
								_tmp32_ = programs_arr;
								_tmp32__length1 = programs_arr_length1;
								if (!(_tmp31_ < _tmp32__length1)) {
									break;
								}
								_tmp33_ = programs_arr;
								_tmp33__length1 = programs_arr_length1;
								_tmp34_ = i;
								_tmp35_ = _tmp33_[_tmp34_];
								_tmp36_ = channel_sid_string;
								if (g_strcmp0 (_tmp35_, _tmp36_) != 0) {
									GeeArrayList* _tmp37_ = NULL;
									gchar** _tmp38_ = NULL;
									gint _tmp38__length1 = 0;
									gint _tmp39_ = 0;
									const gchar* _tmp40_ = NULL;
									_tmp37_ = new_programs_list;
									_tmp38_ = programs_arr;
									_tmp38__length1 = programs_arr_length1;
									_tmp39_ = i;
									_tmp40_ = _tmp38_[_tmp39_];
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp40_);
								}
							}
						}
					}
					_tmp41_ = new_programs_list;
					_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 0);
					_tmp43_ = (gchar*) _tmp42_;
					_tmp44_ = g_string_new (_tmp43_);
					_tmp45_ = _tmp44_;
					_g_free0 (_tmp43_);
					new_programs = _tmp45_;
					{
						gint i = 0;
						i = 1;
						{
							gboolean _tmp46_ = FALSE;
							_tmp46_ = TRUE;
							while (TRUE) {
								gint _tmp48_ = 0;
								GeeArrayList* _tmp49_ = NULL;
								gint _tmp50_ = 0;
								gint _tmp51_ = 0;
								GString* _tmp52_ = NULL;
								GeeArrayList* _tmp53_ = NULL;
								gint _tmp54_ = 0;
								gpointer _tmp55_ = NULL;
								gchar* _tmp56_ = NULL;
								gchar* _tmp57_ = NULL;
								gchar* _tmp58_ = NULL;
								if (!_tmp46_) {
									gint _tmp47_ = 0;
									_tmp47_ = i;
									i = _tmp47_ + 1;
								}
								_tmp46_ = FALSE;
								_tmp48_ = i;
								_tmp49_ = new_programs_list;
								_tmp50_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp49_);
								_tmp51_ = _tmp50_;
								if (!(_tmp48_ < _tmp51_)) {
									break;
								}
								_tmp52_ = new_programs;
								_tmp53_ = new_programs_list;
								_tmp54_ = i;
								_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp54_);
								_tmp56_ = (gchar*) _tmp55_;
								_tmp57_ = g_strconcat (":", _tmp56_, NULL);
								_tmp58_ = _tmp57_;
								g_string_append (_tmp52_, _tmp58_);
								_g_free0 (_tmp58_);
								_g_free0 (_tmp56_);
							}
						}
					}
					_tmp59_ = dvb_player_thread_log;
					_tmp60_ = programs;
					_tmp61_ = new_programs;
					_tmp62_ = _tmp61_->str;
					dvb_logging_logger_debug (_tmp59_, "ChannelFactory.vala:339: Changing program-numbers from %s to %s", _tmp60_, _tmp62_);
					_tmp63_ = self->priv->pipeline;
					gst_element_set_state (_tmp63_, GST_STATE_PAUSED);
					_tmp64_ = self->priv->dvbbasebin;
					_tmp65_ = new_programs;
					_tmp66_ = _tmp65_->str;
					g_object_set ((GObject*) _tmp64_, "program-numbers", _tmp66_, NULL);
					_tmp67_ = dvb_player_thread_set_playing_or_destroy (self);
					if (!_tmp67_) {
						result = FALSE;
						_g_string_free0 (new_programs);
						_g_object_unref0 (new_programs_list);
						programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (programs);
						_g_free0 (channel_sid_string);
						{
							GstElement* _tmp68_ = NULL;
							_tmp68_ = self->priv->pipeline;
							g_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
					_tmp69_ = self->priv->_active_channels;
					_tmp70_ = channel;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp69_, _tmp70_);
					_g_string_free0 (new_programs);
					_g_object_unref0 (new_programs_list);
					programs_arr = (_vala_array_free (programs_arr, programs_arr_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (programs);
					_g_free0 (channel_sid_string);
				}
				_tmp71_ = channel_sid;
				_tmp72_ = sink;
				dvb_player_thread_remove_sink_bin (self, _tmp71_, _tmp72_);
				_tmp73_ = stop_channel;
				if (_tmp73_) {
					DVBLoggingLogger* _tmp74_ = NULL;
					DVBPlayerThreadChannelElements* _tmp75_ = NULL;
					GstElement* _tmp76_ = NULL;
					gchar* _tmp77_ = NULL;
					gchar* _tmp78_ = NULL;
					DVBPlayerThreadChannelElements* _tmp79_ = NULL;
					GstElement* _tmp80_ = NULL;
					GstElement* _tmp81_ = NULL;
					DVBPlayerThreadChannelElements* _tmp82_ = NULL;
					GstElement* _tmp83_ = NULL;
					_tmp74_ = dvb_player_thread_log;
					_tmp75_ = celements;
					_tmp76_ = _tmp75_->tee;
					_tmp77_ = gst_object_get_name ((GstObject*) _tmp76_);
					_tmp78_ = _tmp77_;
					dvb_logging_logger_debug (_tmp74_, "ChannelFactory.vala:354: Removing tee %s from pipeline", _tmp78_);
					_g_free0 (_tmp78_);
					_tmp79_ = celements;
					_tmp80_ = _tmp79_->tee;
					gst_element_set_state (_tmp80_, GST_STATE_NULL);
					_tmp81_ = self->priv->pipeline;
					_tmp82_ = celements;
					_tmp83_ = _tmp82_->tee;
					gst_bin_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gst_bin_get_type (), GstBin), _tmp83_);
					{
						GeeHashMap* _tmp84_ = NULL;
						_tmp84_ = self->priv->elements_map;
						g_rec_mutex_lock (&self->priv->__lock_elements_map);
						{
							GeeHashMap* _tmp85_ = NULL;
							guint _tmp86_ = 0U;
							_tmp85_ = self->priv->elements_map;
							_tmp86_ = channel_sid;
							gee_abstract_map_unset ((GeeAbstractMap*) _tmp85_, (gpointer) ((guintptr) _tmp86_), NULL);
						}
						__finally20:
						{
							GeeHashMap* _tmp87_ = NULL;
							_tmp87_ = self->priv->elements_map;
							g_rec_mutex_unlock (&self->priv->__lock_elements_map);
						}
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							{
								GstElement* _tmp88_ = NULL;
								_tmp88_ = self->priv->pipeline;
								g_rec_mutex_unlock (&self->priv->__lock_pipeline);
							}
							_dvb_player_thread_channel_elements_unref0 (celements);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
				}
			} else {
				gboolean _tmp89_ = FALSE;
				_tmp89_ = stop_channel;
				if (_tmp89_) {
					dvb_player_thread_destroy (self, FALSE);
				} else {
					guint _tmp90_ = 0U;
					GstElement* _tmp91_ = NULL;
					gboolean _tmp92_ = FALSE;
					_tmp90_ = channel_sid;
					_tmp91_ = sink;
					dvb_player_thread_remove_sink_bin (self, _tmp90_, _tmp91_);
					_tmp92_ = dvb_player_thread_set_playing_or_destroy (self);
					if (!_tmp92_) {
						result = FALSE;
						{
							GstElement* _tmp93_ = NULL;
							_tmp93_ = self->priv->pipeline;
							g_rec_mutex_unlock (&self->priv->__lock_pipeline);
						}
						_dvb_player_thread_channel_elements_unref0 (celements);
						return result;
					}
				}
			}
		}
		__finally19:
		{
			GstElement* _tmp94_ = NULL;
			_tmp94_ = self->priv->pipeline;
			g_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_dvb_player_thread_channel_elements_unref0 (celements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_dvb_player_thread_channel_elements_unref0 (celements);
	return result;
}


static gboolean dvb_player_thread_set_playing_or_destroy (DVBPlayerThread* self) {
	gboolean result = FALSE;
	GstStateChangeReturn ret = 0;
	GstElement* _tmp0_ = NULL;
	GstStateChangeReturn _tmp1_ = 0;
	GstStateChangeReturn _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = gst_element_set_state (_tmp0_, GST_STATE_PLAYING);
	ret = _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ == GST_STATE_CHANGE_FAILURE) {
		DVBLoggingLogger* _tmp3_ = NULL;
		_tmp3_ = dvb_player_thread_log;
		dvb_logging_logger_error (_tmp3_, "ChannelFactory.vala:385: Failed setting pipeline to playing");
		dvb_player_thread_destroy (self, FALSE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void dvb_player_thread_remove_sink_bin (DVBPlayerThread* self, guint channel_sid, GstElement* sink) {
	DVBLoggingLogger* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GstElement* sink_bin = NULL;
	guint _tmp6_ = 0U;
	GstElement* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	DVBLoggingLogger* _tmp39_ = NULL;
	GstElement* _tmp40_ = NULL;
	GstElement* _tmp41_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sink != NULL);
	_tmp0_ = dvb_player_thread_log;
	_tmp1_ = sink;
	_tmp2_ = gst_object_get_name ((GstObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sink;
	_tmp5_ = channel_sid;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:393: Removing sink bin of sink %s (%p) of channel " \
"%u", _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = channel_sid;
	_tmp7_ = sink;
	_tmp8_ = dvb_player_thread_get_sink_bin (self, _tmp6_, _tmp7_);
	sink_bin = _tmp8_;
	_tmp9_ = sink_bin;
	if (_tmp9_ == NULL) {
		DVBLoggingLogger* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		GstElement* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GstElement* _tmp15_ = NULL;
		_tmp10_ = dvb_player_thread_log;
		_tmp11_ = channel_sid;
		_tmp12_ = sink;
		_tmp13_ = gst_object_get_name ((GstObject*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = sink;
		dvb_logging_logger_error (_tmp10_, "ChannelFactory.vala:399: Could not find sink bin for channel %u and si" \
"nk %s (%p)", _tmp11_, _tmp14_, _tmp15_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (sink_bin);
		return;
	}
	{
		GeeHashMap* _tmp16_ = NULL;
		_tmp16_ = self->priv->elements_map;
		g_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			DVBPlayerThreadChannelElements* celems = NULL;
			GeeHashMap* _tmp17_ = NULL;
			guint _tmp18_ = 0U;
			gpointer _tmp19_ = NULL;
			DVBLoggingLogger* _tmp20_ = NULL;
			GstElement* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			GstElement* _tmp24_ = NULL;
			DVBPlayerThreadChannelElements* _tmp25_ = NULL;
			GstElement* _tmp26_ = NULL;
			GstElement* _tmp27_ = NULL;
			GstElement* _tmp28_ = NULL;
			DVBPlayerThreadChannelElements* _tmp29_ = NULL;
			GeeArrayList* _tmp30_ = NULL;
			GstElement* _tmp31_ = NULL;
			gboolean _tmp32_ = FALSE;
			_tmp17_ = self->priv->elements_map;
			_tmp18_ = channel_sid;
			_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, (gpointer) ((guintptr) _tmp18_));
			celems = (DVBPlayerThreadChannelElements*) _tmp19_;
			_tmp20_ = dvb_player_thread_log;
			_tmp21_ = sink;
			_tmp22_ = gst_object_get_name ((GstObject*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = sink;
			dvb_logging_logger_debug (_tmp20_, "ChannelFactory.vala:407: Setting state of queue and sink %s (%p) to NU" \
"LL", _tmp23_, _tmp24_);
			_g_free0 (_tmp23_);
			_tmp25_ = celems;
			_tmp26_ = _tmp25_->tee;
			_tmp27_ = sink_bin;
			gst_element_unlink (_tmp26_, _tmp27_);
			_tmp28_ = sink_bin;
			gst_element_set_state (_tmp28_, GST_STATE_NULL);
			_tmp29_ = celems;
			_tmp30_ = _tmp29_->sinks;
			_tmp31_ = sink_bin;
			_tmp32_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp30_, _tmp31_);
			if (!_tmp32_) {
				DVBLoggingLogger* _tmp33_ = NULL;
				GstElement* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				GstElement* _tmp37_ = NULL;
				_tmp33_ = dvb_player_thread_log;
				_tmp34_ = sink_bin;
				_tmp35_ = gst_object_get_name ((GstObject*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = sink_bin;
				dvb_logging_logger_error (_tmp33_, "ChannelFactory.vala:413: Could not find sink bin %s (%p)", _tmp36_, _tmp37_);
				_g_free0 (_tmp36_);
			}
			_dvb_player_thread_channel_elements_unref0 (celems);
		}
		__finally21:
		{
			GeeHashMap* _tmp38_ = NULL;
			_tmp38_ = self->priv->elements_map;
			g_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (sink_bin);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp39_ = dvb_player_thread_log;
	dvb_logging_logger_debug (_tmp39_, "ChannelFactory.vala:418: Removing queue and sink from pipeline");
	_tmp40_ = self->priv->pipeline;
	_tmp41_ = sink_bin;
	gst_bin_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gst_bin_get_type (), GstBin), _tmp41_);
	_g_object_unref0 (sink_bin);
}


/**
         * Stop pipeline and clean up everything else
         */
static void dvb_player_thread_real_destroy (DVBPlayerThread* self, gboolean forced) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->destroyed;
	if (_tmp0_) {
		return;
	}
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = self->priv->destroyed;
		g_rec_mutex_lock (&self->priv->__lock_destroyed);
		{
			gboolean _tmp2_ = FALSE;
			GeeHashSet* _tmp40_ = NULL;
			self->priv->destroyed = TRUE;
			_tmp2_ = forced;
			if (_tmp2_) {
				{
					GeeHashMap* _tmp3_ = NULL;
					_tmp3_ = self->priv->elements_map;
					g_rec_mutex_lock (&self->priv->__lock_elements_map);
					{
						{
							GeeIterator* _celems_it = NULL;
							GeeHashMap* _tmp4_ = NULL;
							GeeCollection* _tmp5_ = NULL;
							GeeCollection* _tmp6_ = NULL;
							GeeCollection* _tmp7_ = NULL;
							GeeIterator* _tmp8_ = NULL;
							GeeIterator* _tmp9_ = NULL;
							_tmp4_ = self->priv->elements_map;
							_tmp5_ = gee_abstract_map_get_values ((GeeMap*) _tmp4_);
							_tmp6_ = _tmp5_;
							_tmp7_ = _tmp6_;
							_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
							_tmp9_ = _tmp8_;
							_g_object_unref0 (_tmp7_);
							_celems_it = _tmp9_;
							while (TRUE) {
								GeeIterator* _tmp10_ = NULL;
								gboolean _tmp11_ = FALSE;
								DVBPlayerThreadChannelElements* celems = NULL;
								GeeIterator* _tmp12_ = NULL;
								gpointer _tmp13_ = NULL;
								DVBPlayerThreadChannelElements* _tmp14_ = NULL;
								DVBForcedStopNotify _tmp15_ = NULL;
								void* _tmp15__target = NULL;
								_tmp10_ = _celems_it;
								_tmp11_ = gee_iterator_next (_tmp10_);
								if (!_tmp11_) {
									break;
								}
								_tmp12_ = _celems_it;
								_tmp13_ = gee_iterator_get (_tmp12_);
								celems = (DVBPlayerThreadChannelElements*) _tmp13_;
								_tmp14_ = celems;
								_tmp15_ = _tmp14_->notify_func;
								_tmp15__target = _tmp14_->notify_func_target;
								if (_tmp15_ != NULL) {
									DVBChannel* channel = NULL;
									DVBDeviceGroup* _tmp16_ = NULL;
									DVBChannelList* _tmp17_ = NULL;
									DVBChannelList* _tmp18_ = NULL;
									DVBPlayerThreadChannelElements* _tmp19_ = NULL;
									guint _tmp20_ = 0U;
									DVBChannel* _tmp21_ = NULL;
									DVBPlayerThreadChannelElements* _tmp22_ = NULL;
									DVBForcedStopNotify _tmp23_ = NULL;
									void* _tmp23__target = NULL;
									DVBChannel* _tmp24_ = NULL;
									_tmp16_ = self->priv->_group;
									_tmp17_ = dvb_device_group_get_Channels (_tmp16_);
									_tmp18_ = _tmp17_;
									_tmp19_ = celems;
									_tmp20_ = _tmp19_->sid;
									_tmp21_ = dvb_channel_list_get_channel (_tmp18_, _tmp20_);
									channel = _tmp21_;
									_tmp22_ = celems;
									_tmp23_ = _tmp22_->notify_func;
									_tmp23__target = _tmp22_->notify_func_target;
									_tmp24_ = channel;
									_tmp23_ (_tmp24_, _tmp23__target);
									_g_object_unref0 (channel);
								}
								_dvb_player_thread_channel_elements_unref0 (celems);
							}
							_g_object_unref0 (_celems_it);
						}
					}
					__finally23:
					{
						GeeHashMap* _tmp25_ = NULL;
						_tmp25_ = self->priv->elements_map;
						g_rec_mutex_unlock (&self->priv->__lock_elements_map);
					}
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						{
							gboolean _tmp26_ = FALSE;
							_tmp26_ = self->priv->destroyed;
							g_rec_mutex_unlock (&self->priv->__lock_destroyed);
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			{
				GstElement* _tmp27_ = NULL;
				_tmp27_ = self->priv->pipeline;
				g_rec_mutex_lock (&self->priv->__lock_pipeline);
				{
					GstElement* _tmp28_ = NULL;
					_tmp28_ = self->priv->pipeline;
					if (_tmp28_ != NULL) {
						DVBLoggingLogger* _tmp29_ = NULL;
						GstBus* bus = NULL;
						GstElement* _tmp30_ = NULL;
						GstBus* _tmp31_ = NULL;
						GstBus* _tmp32_ = NULL;
						GstElement* _tmp33_ = NULL;
						_tmp29_ = dvb_player_thread_log;
						dvb_logging_logger_debug (_tmp29_, "ChannelFactory.vala:443: Stopping pipeline");
						_tmp30_ = self->priv->pipeline;
						_tmp31_ = gst_element_get_bus (_tmp30_);
						bus = _tmp31_;
						_tmp32_ = bus;
						gst_bus_remove_signal_watch (_tmp32_);
						_tmp33_ = self->priv->pipeline;
						gst_element_set_state (_tmp33_, GST_STATE_NULL);
						_g_object_unref0 (bus);
					}
					_g_object_unref0 (self->priv->pipeline);
					self->priv->pipeline = NULL;
				}
				__finally24:
				{
					GstElement* _tmp34_ = NULL;
					_tmp34_ = self->priv->pipeline;
					g_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					{
						gboolean _tmp35_ = FALSE;
						_tmp35_ = self->priv->destroyed;
						g_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			{
				GeeHashMap* _tmp36_ = NULL;
				_tmp36_ = self->priv->elements_map;
				g_rec_mutex_lock (&self->priv->__lock_elements_map);
				{
					GeeHashMap* _tmp37_ = NULL;
					_tmp37_ = self->priv->elements_map;
					gee_abstract_map_clear ((GeeAbstractMap*) _tmp37_);
				}
				__finally25:
				{
					GeeHashMap* _tmp38_ = NULL;
					_tmp38_ = self->priv->elements_map;
					g_rec_mutex_unlock (&self->priv->__lock_elements_map);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					{
						gboolean _tmp39_ = FALSE;
						_tmp39_ = self->priv->destroyed;
						g_rec_mutex_unlock (&self->priv->__lock_destroyed);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp40_ = self->priv->_active_channels;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp40_);
		}
		__finally22:
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = self->priv->destroyed;
			g_rec_mutex_unlock (&self->priv->__lock_destroyed);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_player_thread_destroy (DVBPlayerThread* self, gboolean forced) {
	g_return_if_fail (self != NULL);
	DVB_PLAYER_THREAD_GET_CLASS (self)->destroy (self, forced);
}


static gboolean dvb_player_thread_add_element (DVBPlayerThread* self, GstElement* elem) {
	gboolean result = FALSE;
	gchar* elem_name = NULL;
	GstElement* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	DVBLoggingLogger* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elem != NULL, FALSE);
	_tmp0_ = elem;
	_tmp1_ = gst_object_get_name ((GstObject*) _tmp0_);
	elem_name = _tmp1_;
	_tmp2_ = self->priv->pipeline;
	_tmp3_ = elem;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gst_bin_get_type (), GstBin), _tmp4_);
	if (!_tmp5_) {
		DVBLoggingLogger* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = dvb_player_thread_log;
		_tmp7_ = elem_name;
		dvb_logging_logger_error (_tmp6_, "ChannelFactory.vala:460: Could not add element %s", _tmp7_);
		result = FALSE;
		_g_free0 (elem_name);
		_g_object_unref0 (elem);
		return result;
	}
	_tmp8_ = dvb_player_thread_log;
	_tmp9_ = elem_name;
	_tmp10_ = elem;
	dvb_logging_logger_debug (_tmp8_, "ChannelFactory.vala:463: Element %s (%p) added to pipeline", _tmp9_, _tmp10_);
	result = TRUE;
	_g_free0 (elem_name);
	_g_object_unref0 (elem);
	return result;
}


/**
         * Link program_%d pad with tee
         */
static void dvb_player_thread_link_tee_pad (DVBPlayerThread* self, GstElement* dvbbasebin, GstElement* tee) {
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GstPad* srcpad = NULL;
	GstElement* _tmp8_ = NULL;
	GstPad* _tmp9_ = NULL;
	GstPad* sinkpad = NULL;
	GstElement* _tmp10_ = NULL;
	GstPad* _tmp11_ = NULL;
	GstPadLinkReturn rc = 0;
	GstPad* _tmp12_ = NULL;
	GstPad* _tmp13_ = NULL;
	GstPadLinkReturn _tmp14_ = 0;
	GstPadLinkReturn _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dvbbasebin != NULL);
	g_return_if_fail (tee != NULL);
	_tmp0_ = dvb_player_thread_log;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:472: link_tee_pad");
	_tmp1_ = dvb_player_thread_log;
	_tmp2_ = dvbbasebin;
	_tmp3_ = gst_object_get_name ((GstObject*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = tee;
	_tmp6_ = gst_object_get_name ((GstObject*) _tmp5_);
	_tmp7_ = _tmp6_;
	dvb_logging_logger_debug (_tmp1_, "ChannelFactory.vala:474: Linking elements %s and %s", _tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_tmp8_ = dvbbasebin;
	_tmp9_ = gst_element_get_static_pad (_tmp8_, "src");
	srcpad = _tmp9_;
	_tmp10_ = tee;
	_tmp11_ = gst_element_get_static_pad (_tmp10_, "sink");
	sinkpad = _tmp11_;
	_tmp12_ = srcpad;
	_tmp13_ = sinkpad;
	_tmp14_ = gst_pad_link_full (_tmp12_, _tmp13_, GST_PAD_LINK_CHECK_DEFAULT);
	rc = _tmp14_;
	_tmp15_ = rc;
	if (_tmp15_ != GST_PAD_LINK_OK) {
		DVBLoggingLogger* _tmp16_ = NULL;
		GstPad* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GstPad* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp16_ = dvb_player_thread_log;
		_tmp17_ = srcpad;
		_tmp18_ = gst_object_get_name ((GstObject*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = sinkpad;
		_tmp21_ = gst_object_get_name ((GstObject*) _tmp20_);
		_tmp22_ = _tmp21_;
		dvb_logging_logger_error (_tmp16_, "ChannelFactory.vala:480: Could not link pads %s and %s", _tmp19_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
	} else {
		DVBLoggingLogger* _tmp23_ = NULL;
		GstPad* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		GstPad* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		_tmp23_ = dvb_player_thread_log;
		_tmp24_ = srcpad;
		_tmp25_ = gst_object_get_name ((GstObject*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = sinkpad;
		_tmp28_ = gst_object_get_name ((GstObject*) _tmp27_);
		_tmp29_ = _tmp28_;
		dvb_logging_logger_debug (_tmp23_, "ChannelFactory.vala:482: Src pad %s linked with sink pad %s", _tmp26_, _tmp29_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp26_);
	}
	_g_object_unref0 (sinkpad);
	_g_object_unref0 (srcpad);
}


/**
         * Forward EIT structure
         */
static void _vala_GstMpegtsSection_free (GstMpegtsSection* self) {
	g_boxed_free (gst_mpegts_section_get_type (), self);
}


static void dvb_player_thread_bus_watch_func (DVBPlayerThread* self, GstBus* bus, GstMessage* message) {
	GstStructure* structure = NULL;
	GstMessage* _tmp0_ = NULL;
	GstStructure* _tmp1_ = NULL;
	GstMessage* _tmp2_ = NULL;
	GstMessageType _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bus != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = gst_message_get_structure (_tmp0_);
	structure = _tmp1_;
	_tmp2_ = message;
	_tmp3_ = _tmp2_->type;
	switch (_tmp3_) {
		case GST_MESSAGE_ELEMENT:
		{
			GstMpegtsSection* section = NULL;
			GstMessage* _tmp4_ = NULL;
			GstMpegtsSection* _tmp5_ = NULL;
			GstMpegtsSection* _tmp6_ = NULL;
			_tmp4_ = message;
			_tmp5_ = gst_message_parse_mpegts_section (_tmp4_);
			section = _tmp5_;
			_tmp6_ = section;
			if (_tmp6_ != NULL) {
				GstMpegtsSection* _tmp7_ = NULL;
				GstMpegtsSectionType _tmp8_ = 0;
				_tmp7_ = section;
				_tmp8_ = _tmp7_->section_type;
				if (_tmp8_ == GST_MPEGTS_SECTION_EIT) {
					DVBEPGScanner* _tmp9_ = NULL;
					GstMpegtsSection* _tmp12_ = NULL;
					_tmp9_ = self->priv->epgscanner;
					if (_tmp9_ != NULL) {
						DVBEPGScanner* _tmp10_ = NULL;
						GstMpegtsSection* _tmp11_ = NULL;
						_tmp10_ = self->priv->epgscanner;
						_tmp11_ = section;
						dvb_epg_scanner_on_eit_structure (_tmp10_, _tmp11_);
					}
					_tmp12_ = section;
					g_signal_emit_by_name (self, "eit-structure", _tmp12_);
				}
			}
			__vala_GstMpegtsSection_free0 (section);
			break;
		}
		case GST_MESSAGE_WARNING:
		{
			GstStructure* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp13_ = structure;
			_tmp14_ = gst_structure_to_string (_tmp13_);
			_tmp15_ = _tmp14_;
			g_warning ("ChannelFactory.vala:504: %s", _tmp15_);
			_g_free0 (_tmp15_);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			DVBLoggingLogger* _tmp16_ = NULL;
			GstStructure* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp16_ = dvb_player_thread_log;
			_tmp17_ = structure;
			_tmp18_ = gst_structure_to_string (_tmp17_);
			_tmp19_ = _tmp18_;
			dvb_logging_logger_error (_tmp16_, "ChannelFactory.vala:507: %s", _tmp19_);
			_g_free0 (_tmp19_);
			break;
		}
		default:
		{
			break;
		}
	}
}


GeeHashSet* dvb_player_thread_get_active_channels (DVBPlayerThread* self) {
	GeeHashSet* result;
	GeeHashSet* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_channels;
	result = _tmp0_;
	return result;
}


static void dvb_player_thread_set_active_channels (DVBPlayerThread* self, GeeHashSet* value) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_active_channels);
	self->priv->_active_channels = _tmp1_;
	g_object_notify ((GObject *) self, "active-channels");
}


DVBDevice* dvb_player_thread_get_device (DVBPlayerThread* self) {
	DVBDevice* result;
	DVBDevice* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void dvb_player_thread_set_device (DVBPlayerThread* self, DVBDevice* value) {
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_device);
	self->priv->_device = _tmp1_;
	g_object_notify ((GObject *) self, "device");
}


DVBDeviceGroup* dvb_player_thread_get_group (DVBPlayerThread* self) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}


static void dvb_player_thread_set_group (DVBPlayerThread* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_group);
	self->priv->_group = _tmp1_;
	g_object_notify ((GObject *) self, "group");
}


gboolean dvb_player_thread_get_forced (DVBPlayerThread* self) {
	gboolean result;
	gboolean val = FALSE;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	val = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->elements_map;
		g_rec_mutex_lock (&self->priv->__lock_elements_map);
		{
			{
				GeeIterator* _celem_it = NULL;
				GeeHashMap* _tmp1_ = NULL;
				GeeCollection* _tmp2_ = NULL;
				GeeCollection* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				_tmp1_ = self->priv->elements_map;
				_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_celem_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					DVBPlayerThreadChannelElements* celem = NULL;
					GeeIterator* _tmp9_ = NULL;
					gpointer _tmp10_ = NULL;
					DVBPlayerThreadChannelElements* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp7_ = _celem_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _celem_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					celem = (DVBPlayerThreadChannelElements*) _tmp10_;
					_tmp11_ = celem;
					_tmp12_ = _tmp11_->forced;
					if (_tmp12_) {
						val = TRUE;
						_dvb_player_thread_channel_elements_unref0 (celem);
						break;
					}
					_dvb_player_thread_channel_elements_unref0 (celem);
				}
				_g_object_unref0 (_celem_it);
			}
		}
		__finally26:
		{
			GeeHashMap* _tmp13_ = NULL;
			_tmp13_ = self->priv->elements_map;
			g_rec_mutex_unlock (&self->priv->__lock_elements_map);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp14_ = val;
	result = _tmp14_;
	return result;
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * dvb_player_thread_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBPlayerThread * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_player_thread_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_PLAYER_THREAD, DVBPlayerThread);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, (GBoxedCopyFunc) dvb_player_thread_channel_elements_ref, dvb_player_thread_channel_elements_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->elements_map);
	self->priv->elements_map = _tmp0_;
	_tmp1_ = gee_hash_set_new (DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp2_ = _tmp1_;
	dvb_player_thread_set_active_channels (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	self->priv->destroyed = FALSE;
	return obj;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_construct (GType object_type) {
	DVBPlayerThreadChannelElements* self = NULL;
	self = (DVBPlayerThreadChannelElements*) g_type_create_instance (object_type);
	return self;
}


static DVBPlayerThreadChannelElements* dvb_player_thread_channel_elements_new (void) {
	return dvb_player_thread_channel_elements_construct (DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS);
}


static void dvb_player_thread_value_channel_elements_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void dvb_player_thread_value_channel_elements_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		dvb_player_thread_channel_elements_unref (value->data[0].v_pointer);
	}
}


static void dvb_player_thread_value_channel_elements_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer dvb_player_thread_value_channel_elements_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* dvb_player_thread_value_channel_elements_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DVBPlayerThreadChannelElements* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dvb_player_thread_channel_elements_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* dvb_player_thread_value_channel_elements_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DVBPlayerThreadChannelElements** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* dvb_player_thread_param_spec_channel_elements (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DVBPlayerThreadParamSpecChannelElements* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer dvb_player_thread_value_get_channel_elements (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS), NULL);
	return value->data[0].v_pointer;
}


static void dvb_player_thread_value_set_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dvb_player_thread_channel_elements_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_value_take_channel_elements (GValue* value, gpointer v_object) {
	DVBPlayerThreadChannelElements* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dvb_player_thread_channel_elements_unref (old);
	}
}


static void dvb_player_thread_channel_elements_class_init (DVBPlayerThreadChannelElementsClass * klass) {
	dvb_player_thread_channel_elements_parent_class = g_type_class_peek_parent (klass);
	((DVBPlayerThreadChannelElementsClass *) klass)->finalize = dvb_player_thread_channel_elements_finalize;
}


static void dvb_player_thread_channel_elements_instance_init (DVBPlayerThreadChannelElements * self) {
	self->ref_count = 1;
}


static void dvb_player_thread_channel_elements_finalize (DVBPlayerThreadChannelElements* obj) {
	DVBPlayerThreadChannelElements * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_PLAYER_THREAD_TYPE_CHANNEL_ELEMENTS, DVBPlayerThreadChannelElements);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->sinks);
	_g_object_unref0 (self->tee);
}


static GType dvb_player_thread_channel_elements_get_type (void) {
	static volatile gsize dvb_player_thread_channel_elements_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_channel_elements_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { dvb_player_thread_value_channel_elements_init, dvb_player_thread_value_channel_elements_free_value, dvb_player_thread_value_channel_elements_copy_value, dvb_player_thread_value_channel_elements_peek_pointer, "p", dvb_player_thread_value_channel_elements_collect_value, "p", dvb_player_thread_value_channel_elements_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadChannelElementsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_channel_elements_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThreadChannelElements), 0, (GInstanceInitFunc) dvb_player_thread_channel_elements_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType dvb_player_thread_channel_elements_type_id;
		dvb_player_thread_channel_elements_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DVBPlayerThreadChannelElements", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&dvb_player_thread_channel_elements_type_id__volatile, dvb_player_thread_channel_elements_type_id);
	}
	return dvb_player_thread_channel_elements_type_id__volatile;
}


static gpointer dvb_player_thread_channel_elements_ref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void dvb_player_thread_channel_elements_unref (gpointer instance) {
	DVBPlayerThreadChannelElements* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DVB_PLAYER_THREAD_CHANNEL_ELEMENTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void dvb_player_thread_class_init (DVBPlayerThreadClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_player_thread_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBPlayerThreadPrivate));
	((DVBPlayerThreadClass *) klass)->destroy = dvb_player_thread_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_player_thread_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_player_thread_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_player_thread_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_player_thread_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_ACTIVE_CHANNELS, g_param_spec_object ("active-channels", "active-channels", "active-channels", GEE_TYPE_HASH_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_DEVICE, g_param_spec_object ("device", "device", "device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_GROUP, g_param_spec_object ("group", "group", "group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_PLAYER_THREAD_FORCED, g_param_spec_boolean ("forced", "forced", "forced", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Emitted when we came across EIT table
	         */
	g_signal_new ("eit_structure", DVB_TYPE_PLAYER_THREAD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, gst_mpegts_section_get_type ());
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_player_thread_log = _tmp1_;
}


static void dvb_player_thread_instance_init (DVBPlayerThread * self) {
	self->priv = DVB_PLAYER_THREAD_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_pipeline);
	g_rec_mutex_init (&self->priv->__lock_elements_map);
	g_rec_mutex_init (&self->priv->__lock_destroyed);
}


static void dvb_player_thread_finalize (GObject* obj) {
	DVBPlayerThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_PLAYER_THREAD, DVBPlayerThread);
	_g_object_unref0 (self->priv->_active_channels);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->_group);
	g_rec_mutex_clear (&self->priv->__lock_pipeline);
	_g_object_unref0 (self->priv->pipeline);
	g_rec_mutex_clear (&self->priv->__lock_elements_map);
	_g_object_unref0 (self->priv->elements_map);
	_g_object_unref0 (self->priv->epgscanner);
	_g_object_unref0 (self->priv->dvbbasebin);
	g_rec_mutex_clear (&self->priv->__lock_destroyed);
	G_OBJECT_CLASS (dvb_player_thread_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels one physical device.
     *
     * It's possible to watch multiple channels at the same time
     * if they are all on the same transport stream.
     *
     * The class is able to reuse channels that are already watched
     * and forward EPG data to #EPGScanner.
     */
GType dvb_player_thread_get_type (void) {
	static volatile gsize dvb_player_thread_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_player_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBPlayerThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_player_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBPlayerThread), 0, (GInstanceInitFunc) dvb_player_thread_instance_init, NULL };
		GType dvb_player_thread_type_id;
		dvb_player_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBPlayerThread", &g_define_type_info, 0);
		g_once_init_leave (&dvb_player_thread_type_id__volatile, dvb_player_thread_type_id);
	}
	return dvb_player_thread_type_id__volatile;
}


static void _vala_dvb_player_thread_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_PLAYER_THREAD, DVBPlayerThread);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		g_value_set_object (value, dvb_player_thread_get_active_channels (self));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		g_value_set_object (value, dvb_player_thread_get_device (self));
		break;
		case DVB_PLAYER_THREAD_GROUP:
		g_value_set_object (value, dvb_player_thread_get_group (self));
		break;
		case DVB_PLAYER_THREAD_FORCED:
		g_value_set_boolean (value, dvb_player_thread_get_forced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_player_thread_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBPlayerThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_PLAYER_THREAD, DVBPlayerThread);
	switch (property_id) {
		case DVB_PLAYER_THREAD_ACTIVE_CHANNELS:
		dvb_player_thread_set_active_channels (self, g_value_get_object (value));
		break;
		case DVB_PLAYER_THREAD_DEVICE:
		dvb_player_thread_set_device (self, g_value_get_object (value));
		break;
		case DVB_PLAYER_THREAD_GROUP:
		dvb_player_thread_set_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DVBChannelFactory* dvb_channel_factory_construct (GType object_type, DVBDeviceGroup* devgroup) {
	DVBChannelFactory * self = NULL;
	DVBDeviceGroup* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	g_return_val_if_fail (devgroup != NULL, NULL);
	_tmp0_ = devgroup;
	self = (DVBChannelFactory*) g_object_new (object_type, "device-group", _tmp0_, NULL);
	_tmp1_ = gee_hash_set_new (DVB_TYPE_PLAYER_THREAD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->active_players);
	self->priv->active_players = _tmp1_;
	return self;
}


DVBChannelFactory* dvb_channel_factory_new (DVBDeviceGroup* devgroup) {
	return dvb_channel_factory_construct (DVB_TYPE_CHANNEL_FACTORY, devgroup);
}


/**
         * Stop all currently active players
         */
void dvb_channel_factory_destroy (DVBChannelFactory* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashSet* _tmp0_ = NULL;
		_tmp0_ = self->priv->active_players;
		g_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeHashSet* _tmp8_ = NULL;
			{
				GeeIterator* _active_player_it = NULL;
				GeeHashSet* _tmp1_ = NULL;
				GeeIterator* _tmp2_ = NULL;
				_tmp1_ = self->priv->active_players;
				_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
				_active_player_it = _tmp2_;
				while (TRUE) {
					GeeIterator* _tmp3_ = NULL;
					gboolean _tmp4_ = FALSE;
					DVBPlayerThread* active_player = NULL;
					GeeIterator* _tmp5_ = NULL;
					gpointer _tmp6_ = NULL;
					DVBPlayerThread* _tmp7_ = NULL;
					_tmp3_ = _active_player_it;
					_tmp4_ = gee_iterator_next (_tmp3_);
					if (!_tmp4_) {
						break;
					}
					_tmp5_ = _active_player_it;
					_tmp6_ = gee_iterator_get (_tmp5_);
					active_player = (DVBPlayerThread*) _tmp6_;
					_tmp7_ = active_player;
					dvb_player_thread_destroy (_tmp7_, FALSE);
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			_tmp8_ = self->priv->active_players;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
		}
		__finally27:
		{
			GeeHashSet* _tmp9_ = NULL;
			_tmp9_ = self->priv->active_players;
			g_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * @channel: channel to watch
         * @sink_element: The element the src pad should be linked with
         * @force: Whether to stop a player when there's currently no free device
         * @notify_func: The given function is called when watching the channel
         *   is aborted because a recording on a different transport streams is
         *   about to start
         * @returns: The #PlayerThread used to watch @channel
         *
         * Watch @channel and use @sink_element as sink element
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target) {
	DVBPlayerThread* result = NULL;
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBChannel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	DVBChannel* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gboolean create_new = FALSE;
	DVBPlayerThread* player = NULL;
	DVBDevice* free_device = NULL;
	DVBLoggingLogger* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	DVBPlayerThread* _tmp58_ = NULL;
	DVBChannel* _tmp59_ = NULL;
	GstElement* _tmp60_ = NULL;
	GstElement* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
	DVBForcedStopNotify _tmp63_ = NULL;
	void* _tmp63__target = NULL;
	GstElement* _tmp64_ = NULL;
	GstElement* _tmp65_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (sink_element != NULL, NULL);
	_tmp0_ = dvb_channel_factory_log;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = channel;
	_tmp5_ = dvb_channel_get_Sid (_tmp4_);
	_tmp6_ = _tmp5_;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:558: Watching channel %s (%u)", _tmp3_, _tmp6_);
	create_new = TRUE;
	player = NULL;
	free_device = NULL;
	{
		GeeHashSet* _tmp7_ = NULL;
		_tmp7_ = self->priv->active_players;
		g_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			{
				GeeIterator* _active_player_it = NULL;
				GeeHashSet* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				_tmp8_ = self->priv->active_players;
				_tmp9_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp8_);
				_active_player_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					DVBPlayerThread* active_player = NULL;
					GeeIterator* _tmp12_ = NULL;
					gpointer _tmp13_ = NULL;
					_tmp10_ = _active_player_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _active_player_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					active_player = (DVBPlayerThread*) _tmp13_;
					{
						GeeIterator* _other_channel_it = NULL;
						DVBPlayerThread* _tmp14_ = NULL;
						GeeHashSet* _tmp15_ = NULL;
						GeeHashSet* _tmp16_ = NULL;
						GeeIterator* _tmp17_ = NULL;
						_tmp14_ = active_player;
						_tmp15_ = dvb_player_thread_get_active_channels (_tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp16_);
						_other_channel_it = _tmp17_;
						while (TRUE) {
							GeeIterator* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
							DVBChannel* other_channel = NULL;
							GeeIterator* _tmp20_ = NULL;
							gpointer _tmp21_ = NULL;
							DVBChannel* _tmp22_ = NULL;
							DVBChannel* _tmp23_ = NULL;
							gboolean _tmp24_ = FALSE;
							_tmp18_ = _other_channel_it;
							_tmp19_ = gee_iterator_next (_tmp18_);
							if (!_tmp19_) {
								break;
							}
							_tmp20_ = _other_channel_it;
							_tmp21_ = gee_iterator_get (_tmp20_);
							other_channel = (DVBChannel*) _tmp21_;
							_tmp22_ = channel;
							_tmp23_ = other_channel;
							_tmp24_ = dvb_channel_on_same_transport_stream (_tmp22_, _tmp23_);
							if (_tmp24_) {
								DVBPlayerThread* _tmp25_ = NULL;
								DVBPlayerThread* _tmp26_ = NULL;
								create_new = FALSE;
								_tmp25_ = active_player;
								_tmp26_ = _g_object_ref0 (_tmp25_);
								_g_object_unref0 (player);
								player = _tmp26_;
								_g_object_unref0 (other_channel);
								break;
							}
							_g_object_unref0 (other_channel);
						}
						_g_object_unref0 (_other_channel_it);
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
		}
		__finally28:
		{
			GeeHashSet* _tmp27_ = NULL;
			_tmp27_ = self->priv->active_players;
			g_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_g_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = dvb_channel_factory_log;
	_tmp29_ = create_new;
	_tmp30_ = bool_to_string (_tmp29_);
	_tmp31_ = _tmp30_;
	dvb_logging_logger_debug (_tmp28_, "ChannelFactory.vala:575: Creating new PlayerThread: %s", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = create_new;
	if (_tmp32_) {
		DVBDeviceGroup* _tmp33_ = NULL;
		DVBDeviceGroup* _tmp34_ = NULL;
		DVBDevice* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		DVBDevice* _tmp37_ = NULL;
		DVBDevice* _tmp54_ = NULL;
		DVBDevice* _tmp56_ = NULL;
		DVBPlayerThread* _tmp57_ = NULL;
		_tmp33_ = self->priv->_device_group;
		dvb_device_group_stop_epg_scanner (_tmp33_);
		_tmp34_ = self->priv->_device_group;
		_tmp35_ = dvb_device_group_get_next_free_device (_tmp34_);
		_g_object_unref0 (free_device);
		free_device = _tmp35_;
		_tmp37_ = free_device;
		if (_tmp37_ == NULL) {
			gboolean _tmp38_ = FALSE;
			_tmp38_ = force;
			_tmp36_ = _tmp38_;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			DVBDeviceGroup* _tmp52_ = NULL;
			DVBDevice* _tmp53_ = NULL;
			{
				GeeHashSet* _tmp39_ = NULL;
				_tmp39_ = self->priv->active_players;
				g_rec_mutex_lock (&self->priv->__lock_active_players);
				{
					{
						GeeIterator* _active_player_it = NULL;
						GeeHashSet* _tmp40_ = NULL;
						GeeIterator* _tmp41_ = NULL;
						_tmp40_ = self->priv->active_players;
						_tmp41_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp40_);
						_active_player_it = _tmp41_;
						while (TRUE) {
							GeeIterator* _tmp42_ = NULL;
							gboolean _tmp43_ = FALSE;
							DVBPlayerThread* active_player = NULL;
							GeeIterator* _tmp44_ = NULL;
							gpointer _tmp45_ = NULL;
							DVBPlayerThread* _tmp46_ = NULL;
							gboolean _tmp47_ = FALSE;
							gboolean _tmp48_ = FALSE;
							_tmp42_ = _active_player_it;
							_tmp43_ = gee_iterator_next (_tmp42_);
							if (!_tmp43_) {
								break;
							}
							_tmp44_ = _active_player_it;
							_tmp45_ = gee_iterator_get (_tmp44_);
							active_player = (DVBPlayerThread*) _tmp45_;
							_tmp46_ = active_player;
							_tmp47_ = dvb_player_thread_get_forced (_tmp46_);
							_tmp48_ = _tmp47_;
							if (!_tmp48_) {
								DVBPlayerThread* _tmp49_ = NULL;
								_tmp49_ = active_player;
								dvb_player_thread_destroy (_tmp49_, TRUE);
								_g_object_unref0 (active_player);
								break;
							} else {
								DVBLoggingLogger* _tmp50_ = NULL;
								_tmp50_ = dvb_channel_factory_log;
								dvb_logging_logger_error (_tmp50_, "ChannelFactory.vala:589: No active players that are not forced");
							}
							_g_object_unref0 (active_player);
						}
						_g_object_unref0 (_active_player_it);
					}
				}
				__finally29:
				{
					GeeHashSet* _tmp51_ = NULL;
					_tmp51_ = self->priv->active_players;
					g_rec_mutex_unlock (&self->priv->__lock_active_players);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (free_device);
					_g_object_unref0 (player);
					_g_object_unref0 (sink_element);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp52_ = self->priv->_device_group;
			_tmp53_ = dvb_device_group_get_next_free_device (_tmp52_);
			_g_object_unref0 (free_device);
			free_device = _tmp53_;
		}
		_tmp54_ = free_device;
		if (_tmp54_ == NULL) {
			DVBLoggingLogger* _tmp55_ = NULL;
			_tmp55_ = dvb_channel_factory_log;
			dvb_logging_logger_info (_tmp55_, "ChannelFactory.vala:596: All devices are busy");
			result = NULL;
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_g_object_unref0 (sink_element);
			return result;
		}
		_tmp56_ = free_device;
		_tmp57_ = dvb_channel_factory_create_player (self, _tmp56_);
		_g_object_unref0 (player);
		player = _tmp57_;
	}
	_tmp58_ = player;
	_tmp59_ = channel;
	_tmp60_ = sink_element;
	_tmp61_ = _g_object_ref0 (_tmp60_);
	_tmp62_ = force;
	_tmp63_ = notify_func;
	_tmp63__target = notify_func_target;
	_tmp64_ = dvb_player_thread_get_element (_tmp58_, _tmp59_, _tmp61_, _tmp62_, _tmp63_, _tmp63__target);
	_tmp65_ = _tmp64_;
	_g_object_unref0 (_tmp65_);
	{
		GeeHashSet* _tmp66_ = NULL;
		_tmp66_ = self->priv->active_players;
		g_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			GeeHashSet* _tmp67_ = NULL;
			DVBPlayerThread* _tmp68_ = NULL;
			_tmp67_ = self->priv->active_players;
			_tmp68_ = player;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
		}
		__finally30:
		{
			GeeHashSet* _tmp69_ = NULL;
			_tmp69_ = self->priv->active_players;
			g_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (free_device);
			_g_object_unref0 (player);
			_g_object_unref0 (sink_element);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = player;
	_g_object_unref0 (free_device);
	_g_object_unref0 (sink_element);
	return result;
}


/**
         * @returns: TRUE on success
         *
         * Stop watching @channel
         */
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBChannel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	DVBChannel* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gboolean success = FALSE;
	DVBPlayerThread* player = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	g_return_val_if_fail (sink != NULL, FALSE);
	_tmp0_ = dvb_channel_factory_log;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = channel;
	_tmp5_ = dvb_channel_get_Sid (_tmp4_);
	_tmp6_ = _tmp5_;
	dvb_logging_logger_debug (_tmp0_, "ChannelFactory.vala:617: Stopping channel %s (%u)", _tmp3_, _tmp6_);
	success = FALSE;
	player = NULL;
	{
		GeeHashSet* _tmp7_ = NULL;
		_tmp7_ = self->priv->active_players;
		g_rec_mutex_lock (&self->priv->__lock_active_players);
		{
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			GeeHashSet* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			{
				GeeIterator* _active_player_it = NULL;
				GeeHashSet* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				_tmp8_ = self->priv->active_players;
				_tmp9_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp8_);
				_active_player_it = _tmp9_;
				while (TRUE) {
					GeeIterator* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					DVBPlayerThread* active_player = NULL;
					GeeIterator* _tmp12_ = NULL;
					gpointer _tmp13_ = NULL;
					DVBPlayerThread* _tmp14_ = NULL;
					GeeHashSet* _tmp15_ = NULL;
					GeeHashSet* _tmp16_ = NULL;
					DVBChannel* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					_tmp10_ = _active_player_it;
					_tmp11_ = gee_iterator_next (_tmp10_);
					if (!_tmp11_) {
						break;
					}
					_tmp12_ = _active_player_it;
					_tmp13_ = gee_iterator_get (_tmp12_);
					active_player = (DVBPlayerThread*) _tmp13_;
					_tmp14_ = active_player;
					_tmp15_ = dvb_player_thread_get_active_channels (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = channel;
					_tmp18_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					if (_tmp18_) {
						DVBPlayerThread* _tmp19_ = NULL;
						DVBChannel* _tmp20_ = NULL;
						GstElement* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						DVBPlayerThread* _tmp23_ = NULL;
						DVBPlayerThread* _tmp24_ = NULL;
						_tmp19_ = active_player;
						_tmp20_ = channel;
						_tmp21_ = sink;
						_tmp22_ = dvb_player_thread_remove_channel (_tmp19_, _tmp20_, _tmp21_);
						success = _tmp22_;
						_tmp23_ = active_player;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (player);
						player = _tmp24_;
						_g_object_unref0 (active_player);
						break;
					}
					_g_object_unref0 (active_player);
				}
				_g_object_unref0 (_active_player_it);
			}
			_tmp26_ = success;
			if (_tmp26_) {
				DVBPlayerThread* _tmp27_ = NULL;
				GeeHashSet* _tmp28_ = NULL;
				GeeHashSet* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				_tmp27_ = player;
				_tmp28_ = dvb_player_thread_get_active_channels (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp25_ = _tmp31_ == 0;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				GeeHashSet* _tmp32_ = NULL;
				DVBPlayerThread* _tmp33_ = NULL;
				_tmp32_ = self->priv->active_players;
				_tmp33_ = player;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp32_, _tmp33_);
			}
			_tmp34_ = self->priv->active_players;
			_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == 0) {
				DVBDeviceGroup* _tmp37_ = NULL;
				_tmp37_ = self->priv->_device_group;
				dvb_device_group_start_epg_scanner (_tmp37_);
			}
		}
		__finally31:
		{
			GeeHashSet* _tmp38_ = NULL;
			_tmp38_ = self->priv->active_players;
			g_rec_mutex_unlock (&self->priv->__lock_active_players);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (player);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (player);
	return result;
}


/**
         * @returns: a new #PlayerThread instance for @device
         */
static DVBPlayerThread* dvb_channel_factory_real_create_player (DVBChannelFactory* self, DVBDevice* device) {
	DVBPlayerThread* result = NULL;
	DVBDevice* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	DVBEPGScanner* _tmp2_ = NULL;
	DVBEPGScanner* _tmp3_ = NULL;
	DVBDeviceGroup* _tmp4_ = NULL;
	DVBPlayerThread* _tmp5_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = self->priv->_device_group;
	_tmp2_ = dvb_device_group_get_epgscanner (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_device_group;
	_tmp5_ = dvb_player_thread_new (_tmp0_, _tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}


DVBPlayerThread* dvb_channel_factory_create_player (DVBChannelFactory* self, DVBDevice* device) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_CHANNEL_FACTORY_GET_CLASS (self)->create_player (self, device);
}


DVBDeviceGroup* dvb_channel_factory_get_device_group (DVBChannelFactory* self) {
	DVBDeviceGroup* result;
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device_group;
	result = _tmp0_;
	return result;
}


static void dvb_channel_factory_set_device_group (DVBChannelFactory* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_device_group = _tmp0_;
	g_object_notify ((GObject *) self, "device-group");
}


static void dvb_channel_factory_class_init (DVBChannelFactoryClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_channel_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelFactoryPrivate));
	((DVBChannelFactoryClass *) klass)->create_player = dvb_channel_factory_real_create_player;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_factory_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FACTORY_DEVICE_GROUP, g_param_spec_object ("device-group", "device-group", "device-group", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_channel_factory_log = _tmp1_;
}


static void dvb_channel_factory_instance_init (DVBChannelFactory * self) {
	self->priv = DVB_CHANNEL_FACTORY_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_active_players);
}


static void dvb_channel_factory_finalize (GObject* obj) {
	DVBChannelFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory);
	g_rec_mutex_clear (&self->priv->__lock_active_players);
	_g_object_unref0 (self->priv->active_players);
	G_OBJECT_CLASS (dvb_channel_factory_parent_class)->finalize (obj);
}


/**
     * This class handles watching channels for a single #DeviceGroup
     */
GType dvb_channel_factory_get_type (void) {
	static volatile gsize dvb_channel_factory_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelFactory), 0, (GInstanceInitFunc) dvb_channel_factory_instance_init, NULL };
		GType dvb_channel_factory_type_id;
		dvb_channel_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelFactory", &g_define_type_info, 0);
		g_once_init_leave (&dvb_channel_factory_type_id__volatile, dvb_channel_factory_type_id);
	}
	return dvb_channel_factory_type_id__volatile;
}


static void _vala_dvb_channel_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		g_value_set_object (value, dvb_channel_factory_get_device_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory);
	switch (property_id) {
		case DVB_CHANNEL_FACTORY_DEVICE_GROUP:
		dvb_channel_factory_set_device_group (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



